<?php
/* This file is part of BBClone (A PHP based Web Counter on Steroids)
 * 
 * SVN FILE $Id: hu.php 417 2022-12-21 11:27:14Z joku $
 *  
 * Copyright (C) 2001-2023, the BBClone Team (see doc/authors.txt for details)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * See doc/copying.txt for details
 */

// Language: Hungarian (Magyar)

// The DNS Extensions array
$extensions = array(
"localdomain" => "helyi",
"numeric" => "Numerikus",
"unknown" => "Ismeretlen",
"museum" => "Múzeum",
"travel" => "utazási",
"ipv4" => "IPv4",
"ipv6" => "IPv6",

"aero" => "Légi",
"arpa" => "Arpa",
"asia" => "Asia-Pacific",
"coop" => "Szövetkezeti",
"info" => "Információs",
"jobs" => "foglalkoztatás",
"mobi" => "Mobile",
"name" => "Személyes",
"post" => "postai szolgáltatások",

"biz" => "Üzleti",
"cat" => "Catalan",
"com" => "Kereskedelmi",
"edu" => "Egyetemi",
"gal" => "Galician",
"gov" => "USA állami",
"int" => "Nemzetközi szervezetek",
"mil" => "USA katonai",
"net" => "Hálózatok",
"org" => "Szervezetek",
"pro" => "Professzionális",
"tel" => "Elérhetőségek",
"xxx" => "pornográf",

"a1" => "Anonymous Proxy",
"a2" => "Satellite Provider",
"ac" => "Ascension-sziget",
"ad" => "Andorra",
"ae" => "Egyesült Arab Emírségek",
"af" => "Afganisztán",
"ag" => "Antigua és Barbuda",
"ai" => "Anguilla",
"al" => "Albánia",
"am" => "Örményország",
"an" => "Holland Antillák",
"ao" => "Angola",
"ap" => "Asia-Pacific",
"aq" => "Antarktisz",
"ar" => "Argentína",
"as" => "Amerikai Szamoa",
"at" => "Ausztria",
"au" => "Ausztrália",
"aw" => "Aruba",
"ax" => "Åland",
"az" => "Azerbajdzsán",
"ba" => "Bosznia-Hercegovina",
"bb" => "Barbadosz",
"bd" => "Banglades",
"be" => "Belgium",
"bf" => "Burkina Faso",
"bg" => "Bulgária",
"bh" => "Bahrein",
"bi" => "Burundi",
"bj" => "Benin",
"bm" => "Bermuda",
"bn" => "Brunei",
"bo" => "Bolívia",
"br" => "Brazília",
"bs" => "Bahama-szigetek",
"bt" => "Bhután",
"bw" => "Botswana",
"by" => "Belorusszia",
"bz" => "Belize",
"ca" => "Kanada",
"cc" => "Kókusz-Szigetek",
"cd" => "Kongó",
"cf" => "Közép-Afrikai Köztársaság",
"cg" => "Kongó",
"ch" => "Svájc",
"ci" => "Elefántcsontpart",
"ck" => "Cook-szigetek",
"cl" => "Chile",
"cm" => "Kamerun",
"cn" => "Kína",
"co" => "Kolumbia",
"cr" => "Costa Rica",
"cu" => "Kuba",
"cv" => "Zöld-foki-szigetek",
"cw" => "Curaçao",
"cx" => "Karácsony-sziget",
"cy" => "Ciprus",
"cz" => "Csehország",
"de" => "Németország",
"dj" => "Dzsibuti",
"dk" => "Dánia",
"dm" => "Dominika",
"do" => "Dominika",
"dz" => "Algéria",
"ec" => "Ecuador",
"ee" => "Észtország",
"eg" => "Egyiptom",
"er" => "Eritrea",
"es" => "Spanyolország",
"et" => "Etiópia",
"eu" => "Európai Közösség",
"fi" => "Finnország",
"fj" => "Fidzsi",
"fk" => "Falkland-szigetek",
"fm" => "Mikronézia",
"fo" => "Feröer-Szigetek",
"fr" => "Franciaország",
"ga" => "Gabon",
"gd" => "Grenada",
"ge" => "Grúzia",
"gf" => "Francia Guyana",
"gg" => "Guernsey",
"gh" => "Ghána",
"gi" => "Gibraltár",
"gl" => "Grönland",
"gm" => "Gambia",
"gn" => "Guinea",
"gp" => "Guadeloupe",
"gq" => "Egyenlítői Guinea",
"gr" => "Görögország",
"gs" => "Dél-Georgia és a Dél-Sandwich-szigetek",
"gt" => "Guatemala",
"gu" => "Guam",
"gw" => "Bissau-Guinea",
"gy" => "Guyana",
"hk" => "Hong Kong",
"hm" => "Heard- és McDonald-szigetek",
"hn" => "Hondurasz",
"hr" => "Horvátország",
"ht" => "Haiti",
"hu" => "Magyarország",
"id" => "Indonézia",
"ie" => "Írország",
"il" => "Izrael",
"im" => "Man-sziget",
"in" => "India",
"io" => "Egyesült Királyság indiai-óceáni tartománya",
"iq" => "Irak",
"ir" => "Irán",
"is" => "Izland",
"it" => "Olaszország",
"je" => "Jersey",
"jm" => "Jamaica",
"jo" => "Jordánia",
"jp" => "Japán",
"ke" => "Kenya",
"kg" => "Kirgizisztán",
"kh" => "Kambodzsa",
"ki" => "Kiribati",
"km" => "Comore-szigetek",
"kn" => "Saint Kitts és Nevis",
"kp" => "Észak-Korea",
"kr" => "Korea",
"kw" => "Kuvait",
"ky" => "Kajmán-szigetek",
"kz" => "Kazahsztán",
"la" => "Laosz",
"lb" => "Libanon",
"lc" => "Szent Lucia",
"li" => "Liechtenstein",
"lk" => "Srí Lanka",
"lr" => "Libéria",
"ls" => "Lesotho",
"lt" => "Litvánia",
"lu" => "Luxemburg",
"lv" => "Lettország",
"ly" => "Líbia",
"ma" => "Marokkó",
"mc" => "Monaco",
"md" => "Moldova",
"me" => "Montenegró",
"mg" => "Madagaszkár",
"mh" => "Marshall-szigetek",
"mk" => "Macedónia",
"ml" => "Mali",
"mm" => "Myanmar",
"mn" => "Mongólia",
"mo" => "Makaó",
"mp" => "Észak-Mariana-szigetek",
"mq" => "Martinique",
"mr" => "Mauritánia",
"ms" => "Montserrat",
"mt" => "Málta",
"mu" => "Mauritius",
"mv" => "Maldív-szigetek",
"mw" => "Malawi",
"mx" => "Mexikó",
"my" => "Malajzia",
"mz" => "Mozambik",
"na" => "Namíbia",
"nc" => "Új-Kaledónia",
"ne" => "Nigéria",
"nf" => "Norfolk-sziget",
"ng" => "Nigéria",
"ni" => "Nicaragua",
"nl" => "Hollandia",
"no" => "Norvégia",
"np" => "Nepál",
"nr" => "Nauru",
"nu" => "Niue",
"nz" => "Új-Zéland",
"om" => "Omán",
"pa" => "Panama",
"pe" => "Peru",
"pf" => "Francia Polinézia",
"pg" => "Pápua Új-Guinea",
"ph" => "Fülöp-szigetek",
"pk" => "Pakisztán",
"pl" => "Lengyelország",
"pm" => "St. Pierre és Miquelon",
"pn" => "Pitcairn",
"pr" => "Puerto Rico",
"ps" => "Palesztina",
"pt" => "Portugália",
"pw" => "Palau",
"py" => "Paraguay",
"qa" => "Katar",
"re" => "Reunion",
"ro" => "Románia",
"rs" => "Szerbia",
"ru" => "Oroszország",
"rw" => "Ruanda",
"sa" => "Szaúd-Arábia",
"sb" => "Salamon-szigetek",
"sc" => "Seychelle-szigetek",
"sd" => "Szudán",
"se" => "Svédország",
"sg" => "Szingapúr",
"sh" => "Szent Ilona",
"si" => "Szlovénia",
"sk" => "Szlovákia",
"sl" => "Sierra Leone",
"sm" => "San Marino",
"sn" => "Szenegál",
"so" => "Szomália",
"sr" => "Suriname",
"st" => "Sao Tome és Principe",
"su" => "Szovjetúnió",
"sv" => "El Salvador",
"sx" => "Sint Maarten",
"sy" => "Szíria",
"sz" => "Szváziföld",
"tc" => "Turks- és Caicos-szigetek",
"td" => "Csád",
"tf" => "Francia Déli Területek",
"tg" => "Togo",
"th" => "Thaiföld",
"tj" => "Tádzsikisztán",
"tk" => "Tokelau",
"tl" => "Kelet-Timor",
"tm" => "Türkmenisztán",
"tn" => "Tunézia",
"to" => "Tonga",
"tp" => "Kelet-Timor",
"tr" => "Törökország",
"tt" => "Trinidad és Tobago",
"tv" => "Tuvalu",
"tw" => "Tajvan",
"tz" => "Tanzánia",
"ua" => "Ukrajna",
"ug" => "Uganda",
"uk" => "Egyesült Királyság",
"us" => "USA",
"uy" => "Uruguay",
"uz" => "Üzbegisztán",
"va" => "Vatikán",
"vc" => "St. Vincent és Grenadines",
"ve" => "Venezuela",
"vg" => "Virgin-szigetek (Egyesült Királyság)",
"vi" => "Virgin-szigetek (USA)",
"vn" => "Vietnám",
"vu" => "Vanuatu",
"wf" => "Wallis és Futuna",
"ws" => "Szamoa",
"ye" => "Jemen",
"yt" => "Mayotte",
"za" => "Dél-Afrika",
"zm" => "Zambia",
"zw" => "Zimbabwe",

// No longer active but needed for history purpose
"bl" => "Saint-Barthélemy",
"bv" => "Bouvet-sziget",
"bq" => "Caribbean Hollandia",
"cs" => "Szerbia és Montenegro",
"eh" => "Nyugat Szahara",
"gb" => "Nagy-Britannia",
"mf" => "Saint-Martin",
"sj" => "Svalbard- és Jan Mayen-szigetek",
"ss" => "Dél-Szudán",
"um" => "USA kisebb távoli szigetek",
"yu" => "Szerbia és Montenegro",
"zr" => "Zaire"
);

// The main Translation array
$translation = array(

// Specific charset
"global_charset" => "utf-8",

// Date format (used with date())
"global_time_format" => "M jS, H:i:s",
"global_day_format" => "l F jS, Y",
"global_hours_format" => "l F jS, G:00",
"global_month_format" => "F Y",

// Global translation
"global_titlebar"=> "Statisztika %SERVER generált %DATE",
"global_bbclone_copyright" => "The BBClone team - Licensz:",
"global_last_reset" => "Statisztika utoljára nullázva: ",
"global_yes" => "igen",
"global_no" => "nem",

// The error messages
"error_cannot_see_config" =>
"Ezen a szerveren a BBClone konfigurációjának megtekintése nem engedélyezett.",
"error_cannot_see_development" =>
"Ezen a szerveren a BBClone regresszió megtekintése nem engedélyezett.",

// Miscellaneous translations
"misc_other" => "egyéb",
"misc_unknown" => "ismeretlen",
"misc_second_unit" => "s",
"misc_ignored" => "figyelmen kívül",

// The Navigation Bar
"navbar_main_site" => "Főoldal",
"navbar_configuration" => "Beállítások",
"navbar_global_stats" => "Általános statisztika",
"navbar_detailed_stats" => "Részletes statisztika",
"navbar_time_stats" => "Idő statisztika",
"navbar_language" => "Nyelv",
"navbar_go" => "megy",

// Detailed Stats words
"dstat_id" => "ID",
"dstat_time" => "Időpont",
"dstat_visits" => "Találat",
"dstat_extension" => "Névvégződés szerint",
"dstat_dns" => "Hosztnév vagy IP",
"dstat_from" => "Honnan",
"dstat_os" => "Op. rendszer",
"dstat_browser" => "Böngésző",
"dstat_visible_rows" => "Felsorolva az utolsó",
"dstat_green_rows" => "zöld sorok",
"dstat_blue_rows" => "kék sorok",
"dstat_red_rows" => "piros sorok",
"dstat_orange_rows" => "narancs sorok",
"dstat_search" => "Kulcsszó",
"dstat_last_page" => "Utolsó oldal",
"dstat_last_visit" => "utolsó találat",
"dstat_robots" => "robotok",
"dstat_my_visit" => "A te IP-dről",
"dstat_no_data" => "nincs adat",
"dstat_prx" => "Proxy szerver",
"dstat_ip" => "IP cím",
"dstat_user_agent" => "Böngésző",
"dstat_nr" => "#",
"dstat_pages" => "Oldalak",
"dstat_visit_length" => "Időtartam",
"dstat_reloads" => "Újratöltés",
"dstat_whois_information" => "Nézz fel információ az IP-cím",

// Global Stats words
"gstat_accesses" => "Találatok száma",
"gstat_total_visits" => "Összes találat",
"gstat_total_unique" => "Összes egyedi",
"gstat_operating_systems" => "Első %d op. rendszer",
"gstat_browsers" => "Első %d böngésző",
"gstat_extensions" => "Első %d névvégződés",
"gstat_robots" => "Első %d robot",
"gstat_pages" => "Első %d látogatott oldal",
"gstat_origins" => "Első %d hivatkozás",
"gstat_hosts" => "Első %d hosztnév",
"gstat_keys" => "Első %d kulcsszó",
"gstat_total" => "Összesen",
"gstat_not_specified" => "meghatározatlan",

// Time Stats words
"tstat_su" => "Vas",
"tstat_mo" => "Hét",
"tstat_tu" => "Ked",
"tstat_we" => "Sze",
"tstat_th" => "Csü",
"tstat_fr" => "Pén",
"tstat_sa" => "Szo",

"tstat_full_su" => "vasárnapi",
"tstat_full_mo" => "Hétfő",
"tstat_full_tu" => "kedd",
"tstat_full_we" => "Szerda",
"tstat_full_th" => "Csütörtök",
"tstat_full_fr" => "Péntek",
"tstat_full_sa" => "Szombat",

"tstat_jan" => "Jan",
"tstat_feb" => "Feb",
"tstat_mar" => "Már",
"tstat_apr" => "Ápr",
"tstat_may" => "Máj",
"tstat_jun" => "Jún",
"tstat_jul" => "Júl",
"tstat_aug" => "Aug",
"tstat_sep" => "Sze",
"tstat_oct" => "Okt",
"tstat_nov" => "Nov",
"tstat_dec" => "Dec",

"tstat_full_jan" => "január",
"tstat_full_feb" => "február",
"tstat_full_mar" => "Március",
"tstat_full_apr" => "Április",
"tstat_full_may" => "május",
"tstat_full_jun" => "június",
"tstat_full_jul" => "július",
"tstat_full_aug" => "augusztus",
"tstat_full_sep" => "Szeptember",
"tstat_full_oct" => "október",
"tstat_full_nov" => "November",
"tstat_full_dec" => "December",

"tstat_last_day" => "Múlt nap",
"tstat_last_week" => "Múlt hét",
"tstat_last_month" => "Múlt hónap",
"tstat_last_year" => "Múlt év",
"tstat_average" => "Átlagos",

// Loadtime notice
"generated" => "oldalon keletkező ",
"seconds" => " másodperc",

// Configuration page words and sentences
"config_variable_name" => "Változó neve",
"config_variable_value" => "Változó értéke",
"config_explanations" => "Magyarázat",

"config_BBC_MAINSITE" =>
"Ennek a változónak a beállításával egy linket határozhatsz meg, amely a
megadott helyre mutat. Alapértelmezésben ez a szülő könyvtár. Abban az
esetben, ha honlapod főoldala valahol máshol található, akkor valószínűleg
annak címét fogod ide beírni.<br />
Például:<br />
\$BBC_MAINSITE = &quot;http://www.myserver.com/&quot;;<br />
\$BBC_MAINSITE = &quot;..&quot;;<br />
\$BBC_MAINSITE = &quot;&quot;;",

"config_BBC_SHOW_CONFIG" =>
"Alapértelmezésben a BBClone konfigurációs beállításai szabadon olvashatók.
Ha ezt nemkívánatosnak tartod, letilthatod az elérését.<br />
Például:<br />
\$BBC_SHOW_CONFIG = 1;<br />
\$BBC_SHOW_CONFIG = &quot;&quot;;",

"config_BBC_TITLEBAR" =>
"A BBClone címsora. Minden oldalon a navigációs sor alatt jelenik meg.
A következő makrókat ismeri:<br /><br />
%SERVER: szerver neve<br />
%DATE: jelen dátum<br /><br />

A HTML cimkék használata megengedett.<br />
Például:<br />
\$BBC_TITLEBAR = &quot;%SERVER szerver statisztika (%DATE)&quot;;<br />
\$BBC_TITLEBAR = &quot;A mai (%DATE) statisztika így néz ki:&quot;;
<br />",

"config_BBC_LANGUAGE" =>
"A BBClone alapértelmezett nyelve, amennyiben a böngésző másként nem
definiálja. Jelenleg a következő nyelvek választhatók:
<p>ar, bg, bs, ca, cs, da, de, el, en, es, fi, fr, hu, id, it, ja, ko, lt, mk, nb,
nl, pl, pt, pt-br, ro, ru, sk, sl, sv, th, tr, ua, zh-cn and zh-tw</p>",

"config_BBC_MAXTIME" =>
"Ez a változó határozza meg az egyedinek tekintett látogatás hosszát
(másodpercben). Egy látogatásnak számít (egyazon látogatótól) minden találat
egészen addig, amíg a két egymást követő találat között eltelt idő túl nem
lépi az itt meghatározott értéket. Alapértelmezett a de facto web szabványnak
tekinthető 30 perc (1800 másodperc), de szükség szerint más érték is
beállítható.<br />
Például:<br />
\$BBC_MAXTIME = 0;<br />
\$BBC_MAXTIME = 1800;",

"config_BBC_MAXVISIBLE" =>
"Mennyi sor jelenjen meg a részletes statisztikában? Az alapértelmezett érték
100. A jelentős mértékű terhelésnövekedés elkerülésének érdekében 500-nál
nagyobbat nem ajánlott beállítani.",

"config_BBC_DETAILED_STAT_FIELDS" =>
"Ez a változó a részletes statisztika oszlopait határozza meg. Lehetséges
értékei:
<ul>
<li>id => Hányadik látogató a számláló indítása óta</li>
<li>time => Az utolsó találat rögzítésének időpontja</li>
<li>visits => Találatok száma az adott látogatás alatt</li>
<li>dns => A látogató gépének hosztneve</li>
<li>ip => A látogató gépének IP címe</li>
<li>os => Az operációs rendszer (ha azonosítható és/vagy nem robot)</li>
<li>browser => A kapcsolat létrehozásakor használt böngésző (ha azonosítható)</li>
<li>ext => A látogató országa a hosztnév végződése alapján</li>
<li>referer => URL, ahonnan a látogató érkezett (referrer)</li>
<li>page => Az utoljára meglátogatott oldal</li>
<li>search => A keresett szó/kifejezés (ha a látogató egy adott kulcsszóra keresve talált ide)</li>
</ul>
A megjelenítés a változó értékeinek itt megadott sorrendje szerint történik.<br />
Például:<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;id, time, visits, ip, ext, os, browser&quot;;
<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;date, ext, browser, os, ip&quot;;<br />",

"config_BBC_TIME_OFFSET" =>
"Amennyiben a szerver órája nem a helyi időzónád szerint jár, akkor ezzel a
változóval beállíthatod a pontos időt (percekben). Negatív érték visszafele,
pozitív pedig értelemszerűen előre állítja azt.<br />
Például:<br />
\$BBC_TIME_OFFSET = 300;<br />
\$BBC_TIME_OFFSET = -300;<br />
\$BBC_TIME_OFFSET = 0;",

"config_BBC_NO_DNS" =>
"Ezzel az opcióval meghatározhatod, hogy az IP címeket feloldja-e a program
hosztnevekre vagy sem. Jóllehet a hosztnevek többet elárulnak a látogatóról,
feloldásuk jelentősen lelassíthatja a gépet, ha a használt DNS szerver lassú,
korlátozott teljesítőképességű vagy megbízhatatlan. Ilyenkor ennek a
változónak a beállítása segíthet megoldani a problémát.<br />
Például:<br />
\$BBC_NO_DNS = 1;<br />
\$BBC_NO_DNS = &quot;&quot;;",

"config_BBC_NO_HITS" =>
"Alapértelmezésben a BBClone a találatok számát mutatja az idő statisztikában,
mert ez hasznos tájékoztatást nyújt a szerver leterheltségéről. Ha mégis
inkább az egyedi látogatások számát szeretnéd az idő statisztika alapjául
használni, akkor ennek a változónak az 1-re állításával ezt megteheted.<br />
Például:<br />
\$BBC_NO_HITS = 1;<br />
\$BBC_NO_HITS = &quot;&quot;;",

"config_BBC_IGNORE_IP" =>
"Ez az opció a megadott IP címeknek vagy címtartományoknak a számolásból
történő kizárására szolgál. Ha több kifejezést is meg akarsz adni, használd
a vesszőt elválasztásként.<br />
Például:<br />
\$BBC_IGNORE_IP = &quot;127., 192.168.&quot;;<br />
\$BBC_IGNORE_IP = &quot;&quot;;",

"config_BBC_IGNORE_REFER" =>
"Ha azt szeretnéd, hogy bizonyos referrerek (ahonnan a látogató pl. egy linkre
kattintva érkezett) ne jelenjenek meg a listában, akkor itt megadhatsz egy
vagy több kulcsszót. Illeszkedés esetén a pgm. az adott referrert blokkolja,
vagyis nem jelenítni meg.<br />
Például:<br />
\$BBC_IGNORE_REFER = &quot;spambot.org, .escort.&quot;;<br />
\$BBC_IGNORE_REFER = &quot;&quot;;",

"config_BBC_IGNORE_BOTS" =>
"Ezzel az opcióval meghatározhatod, hogy a program miként kezelje a
robotokat. Alapértelmezésben a hoszt rangsor kivételével mindenhol figyelembe
veszi őket. Ha egyáltalán nem akarod, hogy a robotokkal is foglalkozzon, akkor
állítsad 2-re és így csak a humán látogatókat jegyzi majd a pgm.<br />
Például:<br />
\$BBC_IGNORE_BOTS = 2;<br />
\$BBC_IGNORE_BOTS = 1;<br />
\$BBC_IGNORE_BOTS = &quot;&quot;;",

"config_BBC_IGNORE_AGENT" =>
"Ezzel az opcióval meghatározhatod, hogy miként különböztesse meg a BBClone
az egyes látogatókat. Alapértelmezésben csak az IP címet veszi figyelembe,
ez a legtöbb esetben valós számokat biztosít. Abban az esetben, ha a
látogatók gyakran proxy szerverről érkeznek, ennek az opciónak az átállítása
(&quot;ignore_agent&quot; jelentése: hagyja figyelmen kívül a böngészőt) reálisabb
adatokat eredményezhet, mert pl. ha az adott IP számról más böngészővel
jön valaki, azt új látogatónak veszi.<br />
Például:<br />
\$BBC_IGNORE_AGENT = 1;<br />
\$BBC_IGNORE_AGENT = &quot;&quot;;",

"config_BBC_KILL_STATS" =>
"Ha valaha is újra szeretnéd indítani a statisztikádat, ennek 1-re állításával
a legközelebbi látogatás alkalmával az adatok törlődnek. Ne felejtsd el aztán
visszaállítani, különben csodálkozol majd, hogy milyen alacsony a forgalom! ;)<br />
Például:<br />
\$BBC_KILL_STATS = 1;<br />
\$BBC_KILL_STATS = &quot;&quot;;",

"config_BBC_PURGE_SINGLE" =>
"A hoszt és a hivatkozási (referrer) statisztikák igen nagy adatmennyiséget
generálhatnak, jóllehet ezek legtöbbjét a csak egyszer (és általában
tévedésből) felbukkanó látogatók adják. Ennek a változónak a beállításával
törölheted ezeket a bejegyzéseket, így az access.php file mérete jelentősen
csökken anélkül, hogy ez a látható hoszt és hivatkozási rangsort befolyásolná.
Ezek a találatok a &quot;meghatározatlan&quot; bejegyzések számát növelik
majd, így az összesítések nem változnak.<br />
Például:<br />
\$BBC_PURGE_SINGLE = 1;<br />
\$BBC_PURGE_SINGLE = &quot;&quot;;",

"config_BBC_LOADTIME" =>
"Generate the page load-time in seconds at bottom of the page.<br />
Examples:<br />
\$BBC_LOADTIME =&quot;&quot;;<br />
\$BBC_LOADTIME = 1;",

"config_BBC_EXT_LOOKUP" =>
"This options defines, whether IP addresses are looked up to determine location (country).<br />
These plug-ins are NO part of BBClone, please keep this in mind.<br />
<ul>
<li>IP2EXT => Use the old IP2EXT to Look-Up IP addresses</li>
<li>GEOIP => Use GeoIP API plug-in</li>
<li>GEOIP-mod => Use GeoIP PHP/Perl Module (geoip.so)</li>
</ul>
Examples:<br />
\$BBC_EXT_LOOKUP =&quot;&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;IP2EXT&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP-mod&quot;;",

"config_BBC_CSS_FILE" =>
"BBClone CSS File Name<br />
Please note; Within this css file you can change the way BBClone looks.<br />
(for example change colors or what text size/fonts are used)<br />
Examples:<br />
\$BBC_CSS_FILE =&quot;bbclone.css&quot;;<br />
\$BBC_CSS_FILE =&quot;other.css&quot;;",

"config_BBC_HITS" =>
"Include BBClone hits within the Stats<br />
Examples:<br />
\$BBC_HITS =1;<br />
\$BBC_HITS =&quot;&quot;;",

"config_BBC_USE_ORIGINAL_URI" =>
"Enable this option when the &quot;Top Visited Pages&quot; URI's are not working due
filtering of the URI. This can happen if you use BBClone with some Content
Management Systems (CMS) which are using very long (complex) URI naming.<br />
IMPORTED NOTE: This option changes how URI's are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_USE_ORIGINAL_URI = 1;	=> No filtering, use original URI<br />
\$BBC_USE_ORIGINAL_URI = &quot;&quot;;	=> Filter URI (default)",

"config_BBC_MAX_PAGENAME" =>
"The max. number of characters for the page name.<br />
Longer page names will be stript down at the front, leading with &quot;...&quot;<br />
IMPORTED NOTE: This option changes how page names are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_MAX_PAGENAME = 60;	=> 60 characters (default)"

);
?>
