<?php
/* This file is part of BBClone (A PHP based Web Counter on Steroids)
 * 
 * SVN FILE $Id: fr.php 417 2022-12-21 11:27:14Z joku $
 *  
 * Copyright (C) 2001-2023, the BBClone Team (see doc/authors.txt for details)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * See doc/copying.txt for details
 */

// Language: French (Français)

// The DNS Extensions array
$extensions = array(
"localdomain" => "Local",
"numeric" => "Numérique",
"unknown" => "Inconnu",
"museum" => "Musée",
"travel" => "Voyage",
"ipv4" => "IPv4",
"ipv6" => "IPv6",

"aero" => "Aéronautique",
"arpa" => "Arpa",
"asia" => "Asie-Pacifique",
"coop" => "Coopérative",
"info" => "Information",
"jobs" => "Emploi",
"mobi" => "Mobiles",
"name" => "Personnel",
"post" => "Poste",

"biz" => "Entreprise",
"cat" => "Catalan",
"com" => "Commercial",
"edu" => "Éducation",
"gal" => "Galicien",
"gov" => "Gouvernement",
"int" => "Organisations Internationales",
"mil" => "Armée Américaine",
"net" => "Réseau",
"org" => "Non commercial",
"pro" => "Professionnel",
"tel" => "Contacts",
"xxx" => "Pornographique",

"a1" => "Anonymous Proxy",
"a2" => "Satellite Provider",
"ac" => "Île de l’Ascension",
"ad" => "Andorre",
"ae" => "Émirats Arabes Unis",
"af" => "Afganistan",
"ag" => "Antigua-et-Barbuda",
"ai" => "Anguilla",
"al" => "Albanie",
"am" => "Arménie",
"an" => "Antilles Néerlandaises",
"ao" => "Angola",
"ap" => "Asie-Pacifique",
"aq" => "Antarctique",
"ar" => "Argentine",
"as" => "Samoa Américaines",
"at" => "Autriche",
"au" => "Australie",
"aw" => "Aruba",
"ax" => "Åland",
"az" => "Azerbaïdjan",
"ba" => "Bosnie-Herzégovine",
"bb" => "La Barbade",
"bd" => "Bangladesh",
"be" => "Belgique",
"bf" => "Burkina Faso",
"bg" => "Bulgarie",
"bh" => "Bahreïn",
"bi" => "Burundi",
"bj" => "Bénin",
"bm" => "Bermudes",
"bn" => "Brunei",
"bo" => "Bolivie",
"br" => "Brésil",
"bs" => "Bahamas",
"bt" => "Bhoutan",
"bw" => "Botswana",
"by" => "Biélorussie",
"bz" => "Belize",
"ca" => "Canada",
"cc" => "Îles Cocos",
"cd" => "République Démocratique du Congo",
"cf" => "République Centrafricaine",
"cg" => "Congo",
"ch" => "Suisse",
"ci" => "Côte d'Ivoire",
"ck" => "Îles Cook",
"cl" => "Chili",
"cm" => "Cameroun",
"cn" => "Chine",
"co" => "Colombie",
"cr" => "Costa Rica",
"cu" => "Cuba",
"cv" => "Cap-Vert",
"cw" => "Curaçao",
"cx" => "Île Christmas",
"cy" => "Chypre",
"cz" => "République Tchèque",
"de" => "Allemagne",
"dj" => "Djibouti",
"dk" => "Danemark",
"dm" => "Dominique",
"do" => "République Dominicaine",
"dz" => "Algérie",
"ec" => "Équateur",
"ee" => "Estonie",
"eg" => "Égypte",
"er" => "Érythrée",
"es" => "Espagne",
"et" => "Éthiopie",
"eu" => "Union Européenne",
"fi" => "Finlande",
"fj" => "Fidji",
"fk" => "Îles Malouines",
"fm" => "Micronésie",
"fo" => "Îles Féroé",
"fr" => "France",
"ga" => "Gabon",
"gd" => "Grenade",
"ge" => "Géorgie",
"gf" => "Guyane Française",
"gg" => "Guernesey",
"gh" => "Ghana",
"gi" => "Gibraltar",
"gl" => "Groenland",
"gm" => "Gambie",
"gn" => "Guinée",
"gp" => "Guadeloupe",
"gq" => "Guinée Équatoriale",
"gr" => "Grèce",
"gs" => "Géorgie du Sud",
"gt" => "Guatemala",
"gu" => "Guam",
"gw" => "Guinée-Bissau",
"gy" => "Guyane",
"hk" => "Hong Kong",
"hm" => "Îles Heard-et-MacDonald",
"hn" => "Honduras",
"hr" => "Croatie",
"ht" => "Haïti",
"hu" => "Hongrie",
"id" => "Indonésie",
"ie" => "Irlande",
"il" => "Israël",
"im" => "Île de Man",
"in" => "Inde",
"io" => "Territoire Britannique de l'océan Indien",
"iq" => "Irak",
"ir" => "Iran",
"is" => "Islande",
"it" => "Italie",
"je" => "Jersey",
"jm" => "Jamaïque",
"jo" => "Jordanie",
"jp" => "Japon",
"ke" => "Kenya",
"kg" => "Kirghizistan",
"kh" => "Cambodge",
"ki" => "Kiribati",
"km" => "Comores",
"kn" => "Saint-Christophe-et-Niévès",
"kp" => "Corée du Nord",
"kr" => "Corée du Sud",
"kw" => "Koweït",
"ky" => "Îles Caïmans",
"kz" => "Kazakhstan",
"la" => "Laos",
"lb" => "Liban",
"lc" => "Sainte-Lucie",
"li" => "Liechtenstein",
"lk" => "Sri Lanka",
"lr" => "Libéria",
"ls" => "Lesotho",
"lt" => "Lituanie",
"lu" => "Luxembourg",
"lv" => "Lettonie",
"ly" => "Libye",
"ma" => "Maroc",
"mc" => "Monaco",
"md" => "Moldavie",
"me" => "Monténégro",
"mg" => "Madagascar",
"mh" => "Îles Marshall",
"mk" => "Macédoine",
"ml" => "Mali",
"mm" => "Birmanie",
"mn" => "Mongolie",
"mo" => "Macao",
"mp" => "Îles Mariannes du Nord",
"mq" => "Martinique",
"mr" => "Mauritanie",
"ms" => "Montserrat",
"mt" => "Malte",
"mu" => "Maurice",
"mv" => "Maldives",
"mw" => "Malawi",
"mx" => "Mexique",
"my" => "Malaisie",
"mz" => "Mozambique",
"na" => "Namibie",
"nc" => "Nouvelle-Calédonie",
"ne" => "Niger",
"nf" => "Île Norfolk",
"ng" => "Nigeria",
"ni" => "Nicaragua",
"nl" => "Pays-Bas",
"no" => "Norvège",
"np" => "Népal",
"nr" => "Nauru",
"nu" => "Niue",
"nz" => "Nouvelle-Zélande",
"om" => "Oman",
"pa" => "Panama",
"pe" => "Pérou",
"pf" => "Polynésie Française",
"pg" => "Papouasie-Nouvelle-Guinée",
"ph" => "Philippines",
"pk" => "Pakistan",
"pl" => "Pologne",
"pm" => "Saint-Pierre-et-Miquelon",
"pn" => "Pitcairn",
"pr" => "Porto Rico",
"ps" => "Palestine",
"pt" => "Portugal",
"pw" => "Palaos",
"py" => "Paraguay",
"qa" => "Qatar",
"re" => "La Réunion",
"ro" => "Roumanie",
"rs" => "Serbie",
"ru" => "Russie",
"rw" => "Rwanda",
"sa" => "Arabie Saoudite",
"sb" => "Salomon",
"sc" => "Seychelles",
"sd" => "Soudan",
"se" => "Suède",
"sg" => "Singapour",
"sh" => "Sainte-Hélène",
"si" => "Slovénie",
"sk" => "Slovaquie",
"sl" => "Sierra Leone",
"sm" => "Saint-Marin",
"sn" => "Sénégal",
"so" => "Somalie",
"sr" => "Suriname",
"st" => "Sao Tomé-et-Principe",
"su" => "Union Soviétique",
"sv" => "Salvador",
"sx" => "Saint-Martin",
"sy" => "Syrie",
"sz" => "Swaziland",
"tc" => "Îles Turques et Caïques",
"td" => "Tchad",
"tf" => "Terres Français du Sud",
"tg" => "Togo",
"th" => "Thaïlande",
"tj" => "Tadjikistan",
"tk" => "Tokelau",
"tl" => "Timor Oriental",
"tm" => "Turkménistan",
"tn" => "Tunisie",
"to" => "Tonga",
"tp" => "Timor Oriental",
"tr" => "Turquie",
"tt" => "Trinité-et-Tobago",
"tv" => "Tuvalu",
"tw" => "Taïwan",
"tz" => "Tanzanie",
"ua" => "Ukraine",
"ug" => "Ouganda",
"uk" => "Royaume-Uni",
"us" => "États-Unis",
"uy" => "Uruguay",
"uz" => "Ouzbékistan",
"va" => "Vatican",
"vc" => "Saint-Vincent-et-les Grenadines",
"ve" => "Venezuela",
"vg" => "Îles Vierges Britanniques",
"vi" => "Îles Vierges Américaines",
"vn" => "Viêt Nam",
"vu" => "Vanuatu",
"wf" => "Wallis-et-Futuna",
"ws" => "Samoa",
"ye" => "Yémen",
"yt" => "Mayotte",
"za" => "Afrique du Sud",
"zm" => "Zambie",
"zw" => "Zimbabwe",

// No longer active but needed for history purpose
"bl" => "Saint-Barthélemy",
"bv" => "Île Bouvet",
"bq" => "Pays-Bas Caribéens",
"cs" => "Serbie-et-Monténégroo",
"eh" => "Sahara occidental",
"gb" => "Grande-Bretagne",
"mf" => "Saint-Martin",
"sj" => "Îles Svalbard et Jan Mayen",
"ss" => "Soudan du Sud",
"um" => "Îles Américaines Mineures",
"yu" => "Serbie ou Monténégro",
"zr" => "Zaïre"
);

// The nain Translation array
$translation = array(

// Specific charset
"global_charset" => "utf-8",

// Date format (used with date() )
"global_time_format" => "j M, H:i:s",
"global_day_format" => "l j F Y",
"global_hours_format" => "l j F, G:00",
"global_month_format" => "F Y",

// Global translation
"global_titlebar" => "Statistiques sur %SERVER le %DATE",
"global_bbclone_copyright" => "L'Équipe BBClone - Licence ",
"global_last_reset" => "Statistiques réinitialisées le",
"global_yes" => "oui",
"global_no" => "non",

// The error messages
"error_cannot_see_config" =>
"Vous n'avez pas l'autorisation de visualiser la configuration de BBClone sur ce serveur",

// Miscellaneous translations
"misc_other" => "Autre",
"misc_unknown" => "Inconnu",
"misc_second_unit" => "s",
"misc_ignored" => "Ignoré",

// The Navigation Bar
"navbar_main_site" => "Site principal",
"navbar_configuration" => "Configuration",
"navbar_global_stats" => "Statistiques Globales",
"navbar_detailed_stats" => "Statistiques Détaillées",
"navbar_time_stats" => "Statistiques Temporelles",
"navbar_language" => "Langue",
"navbar_go" => "Go",

// Detailed Stats words
"dstat_id" => "Id",
"dstat_time" => "Date",
"dstat_visits" => "Visites",
"dstat_extension" => "Extension",
"dstat_dns" => "Nom de domaine",
"dstat_from" => "À partir de",
"dstat_os" => "SE",
"dstat_browser" => "Navigateur",
"dstat_visible_rows" => "Accès visibles",
"dstat_green_rows" => "lignes vertes",
"dstat_blue_rows" => "lignes bleues",
"dstat_red_rows" => "lignes rouges",
"dstat_orange_rows" => "lignes oranges",
"dstat_search" => "Recherche",
"dstat_last_page" => "dernière page",
"dstat_last_visit" => "dernière visite",
"dstat_robots" => "Robots",
"dstat_my_visit" => "Visites depuis votre IP",
"dstat_no_data" => "Pas de donnée disponible",
"dstat_prx" => "Proxy",
"dstat_ip" => "Adresse IP",
"dstat_user_agent" => "Identité du navigateur",
"dstat_nr" => "Non",
"dstat_pages" => "Titre de la page",
"dstat_visit_length" => "Durée",
"dstat_reloads" => "Page rechargée",
"dstat_whois_information" => "Informations sur cette adresse IP",

// Global Stats words
"gstat_accesses" => "Accès",
"gstat_total_visits" => "Total des pages visitées",
"gstat_total_unique" => "Nombre de visiteurs",
"gstat_operating_systems" =>"Les %d premiers Systèmes",
"gstat_browsers" => "Les %d premiers Navigateurs",
"gstat_extensions" => "Les %d premières Extensions",
"gstat_robots" => "Les %d premiers Robots",
"gstat_pages" => "Les %d p premières Pages",
"gstat_origins" => "Les %d premières Provenances",
"gstat_hosts" => "Les %d premiers Domaines",
"gstat_keys" => "Les %d premiers Mots-clés",
"gstat_total" => "Total",
"gstat_not_specified" => "Non specifié",

// Time Stats words
"tstat_su" => "Dim",
"tstat_mo" => "Lun",
"tstat_tu" => "Mar",
"tstat_we" => "Mer",
"tstat_th" => "Jeu",
"tstat_fr" => "Ven",
"tstat_sa" => "Sam",

"tstat_full_su" => "Dimanche",
"tstat_full_mo" => "Lundi",
"tstat_full_tu" => "Mardi",
"tstat_full_we" => "Mercredi",
"tstat_full_th" => "Jeudi",
"tstat_full_fr" => "Vendredi",
"tstat_full_sa" => "Samedi",

"tstat_jan" => "Jan",
"tstat_feb" => "Fév",
"tstat_mar" => "Mar",
"tstat_apr" => "Avr",
"tstat_may" => "Mai",
"tstat_jun" => "Jun",
"tstat_jul" => "Jul",
"tstat_aug" => "Aoû",
"tstat_sep" => "Sep",
"tstat_oct" => "Oct",
"tstat_nov" => "Nov",
"tstat_dec" => "Déc",

"tstat_full_jan" => "Janvier",
"tstat_full_feb" => "Février",
"tstat_full_mar" => "Mars",
"tstat_full_apr" => "Avril",
"tstat_full_may" => "Mai",
"tstat_full_jun" => "Juin",
"tstat_full_jul" => "Juillet",
"tstat_full_aug" => "Août",
"tstat_full_sep" => "Septembre",
"tstat_full_oct" => "Octobre",
"tstat_full_nov" => "Novembre",
"tstat_full_dec" => "Décembre",

"tstat_last_day" => "La dernière journée",
"tstat_last_week" => "La dernière semaine",
"tstat_last_month" => "Le dernier mois",
"tstat_last_year" => "La dernière année",
"tstat_average" => "Moyenne",

// Loadtime notice
"generated" => "page générée en ",
"seconds" => " secondes",

// Configuration page words and sentences
"config_variable_name" => "Nom de la variable",
"config_variable_value" => "Valeur de la variable",
"config_explanations" => "Explications",

"config_BBC_MAINSITE" =>
"Si cette variable a été renseignée, un lien sera créé vers l'adresse spécifiée. 
Par défaut, le lien pointe vers le répertoire parent. Dans le cas où votre site 
est situé à une autre adresse, vous aurez surement envie d'adapter cette valeur 
à vos besoins.<br />
Exemples:<br />
\$BBC_MAINSITE = &quot;http://www.mon-serveur.com/&quot;;<br />
\$BBC_MAINSITE = &quot;..&quot;;<br />
\$BBC_MAINSITE = &quot;&quot;;",

"config_BBC_SHOW_CONFIG" =>
"Par défaut, BBClone donne l'accès à ses valeurs de configuration. Si vous ne
souhaitez pas proposer cette option, désactivez-là pour en interdire l'accès.<br />
Exemples:<br />
\$BBC_SHOW_CONFIG = 1;<br />
\$BBC_SHOW_CONFIG = &quot;&quot;;",

"config_BBC_TITLEBAR" =>
"Le nom de vos pages de statistiques.<br />
Le titre qui apparaît sous la barre de navigation de chaque page BBClone.<br />
Les macros reconnues sont:<br />
<ul>
<li>%SERVER: le nom du site,</li>
<li>%DATE: la date courante.</li>
</ul>
Les balises HTML sont autorisées.<br />
Exemples:<br />
\$BBC_TITLEBAR = &quot;Statistiques de %SERVER générées le %DATE&quot;;<br />
\$BBC_TITLEBAR = &quot;Voici mes statistiques au %DATE:&quot;;
<br />",

"config_BBC_LANGUAGE" =>
"La langue par défaut de BBClone, au cas où elle n'a pas été spécifiée par
le navigateur. Voici les langues supportées: 
<p>ar, bg, bs, ca, cs, da, de, el, en, es, fi, fr, hu, id, it, ja, ko, lt, mk, nb,
nl, pl, pt, pt-br, ro, ru, sk, sl, sv, th, tr, ua, zh-cn and zh-tw</p>",

"config_BBC_MAXTIME" =>
"Cette variable définit la durée d'une visite unique (session) en secondes.
Chaque requête provenant du même visiteur, pendant cette durée, sera considérée
comme une seule visite, aussi longtemps que deux requêtes successives ne
dépasseront pas cette durée. La valeur par défaut est celle utilisée en
standard sur les serveurs, soit 30 minutes (1800 secondes), mais vous pouvez
attribuer une valeur différente selon vos besoins.<br />
Exemples:<br />
\$BBC_MAXTIME = 0;<br />
\$BBC_MAXTIME = 1800;",

"config_BBC_MAXVISIBLE" =>
"Combien d'entrées doivent être répertoriées dans les statistiques détaillées ?<br />
Par défaut, les 100 premières seront visibles. Il est conseillé de ne pas
dépasser 500 pour ne pas surcharger les pages.",

"config_BBC_DETAILED_STAT_FIELDS" =>
"La variable \$BBC_DETAILED_STAT_FIELDS détermine les colonnes à afficher dans
les statistiques détaillées. Voici les colonnes disponibles:
<ul>
<li>id => Le Nième visiteur depuis le début des statistiques</li>
<li>time => La date de la dernière requête</li>
<li>visits => Les requêtes par visiteur</li>
<li>dns => Le domaine du visiteur</li>
<li>ip => L'adresse IP du visiteur</li>
<li>os => Le système d'exploitation (si disponible et/ou pas un robot)</li>
<li>browser => Le programme utilisé pour se connecter</li>
<li>ext => Le pays ou l'extention du visiteur</li>
<li>referer => D'où vient le visiteur (le référent)</li>
<li>page => La dernière page visitée</li>
<li>search  => Les mots-clés de recherche utilisés par le visiteur (si disponible)</li>
</ul>
L'odre des colonnes affichées sera le même que celui que vous aurez choisi.<br />
Exemples:<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;id, time, visits, ip, ext, os, browser&quot;;
<br />
\$BBC_DETAILED_STAT_FIELDS = &quot;date, ext, browser, os, ip&quot;, referer;<br />",

"config_BBC_TIME_OFFSET" =>
"Au cas où l'heure ne correspondrait pas à votre fuseau horaire, vous pouvez
l'ajuster en utilisant cette variable. Une valeur négative reculera l'heure,
une positive l'avancera.<br />
Exemples:<br />
\$BBC_TIME_OFFSET = 300;<br />
\$BBC_TIME_OFFSET = -300;<br />
\$BBC_TIME_OFFSET = 0;",

"config_BBC_NO_DNS" =>
"Cette option définit si le nom de domaine doit être déduit de l'adresse IP
ou non. Même si les noms de domaines sont plus parlant sur l'origine des visiteurs,
leur déduction peut considérablement ralentir votre site si les serveurs DNS
utilisés sont lents, de capacités réduites ou simplement peu fiables.
Activer cette option peut éviter des soucis de lenteur.<br />
Exemples:<br />
\$BBC_NO_DNS = 1;<br />
\$BBC_NO_DNS = &quot;&quot;;",

"config_BBC_NO_HITS" =>
"BBClone est configuré par défaut pour montrer, dans les statistiques
temporelles, le nombre de pages consultées, ce qui donne une réelle image de la
charge du serveur. Maintenant, si vous préférez afficher le nombre de visiteurs
dans vos statistiques temporelles, vous n'avez qu'à activer cette option.<br />
Exemples:<br />
\$BBC_NO_HITS = 1;<br />
\$BBC_NO_HITS = &quot;&quot;;",

"config_BBC_IGNORE_IP" =>
"Cette option permet d'exclure du comptage certaines adresses IP ou des groupes
d'adresses. Pour ajouter plusieurs valeurs, utilisez une virgule comme séparateur.<br />
Exemples:<br />
\$BBC_IGNORE_IP = &quot;127., 192.168.&quot;;<br />
\$BBC_IGNORE_IP = &quot;&quot;;",

"config_BBC_IGNORE_REFER" =>
"Dans le cas où vous ne voudriez pas voir apparaître les référents dans les
listes ou dans les stastistiques détaillées, vous pouvez indiquer un ou plusieurs
mots clés pour bloquer ces référents. Si vous utilisez plusieurs mots, merci
d'utiliser une virgule comme séparateur.<br />
Exemples:<br />
\$BBC_IGNORE_REFER = &quot;robot-spam.org, .escort.&quot;;<br />
\$BBC_IGNORE_REFER = &quot;&quot;;",

"config_BBC_IGNORE_BOTS" =>
"Vous pouvez utiliser cette option pour déterminer la méthode d'analyse du
passage des robots. Par défault, les noms de domaines des robots sont exclut
de vos listes de statistiques globales. Si vous ne voulez pas voir apparaître les
traces de leurs passages, et ainsi ne tenir compte que des visites humaines,
passez cette option à &quot;2&quot;.<br />
Exemples:<br />
\$BBC_IGNORE_BOTS = 2;<br />
\$BBC_IGNORE_BOTS = 1;<br />
\$BBC_IGNORE_BOTS = &quot;&quot;;",

"config_BBC_IGNORE_AGENT" =>
"Cette option définit comment BBClone distingue un visiteur d'un autre.
Par défaut il utilise seulement l'adresse IP, ce qui fourni des profils réalistes
dans la majorité des cas. Maintenant, si vos visiteurs sont souvent cachés
derrière des serveurs proxy, la désactivation de cette option peut fournir des
profils plus réalistes, puisqu'un nouveau visiteur sera pris en compte à chaque
changement de navigateur.<br />
Exemples:<br />
\$BBC_IGNORE_AGENT = 1;<br />
\$BBC_IGNORE_AGENT = &quot;&quot;;",

"config_BBC_KILL_STATS" =>
"Dès que vous voulez réinitialiser vos statistiques, activez cette commande:
les statistiques accumulées seront effacées par la visite suivante.
N'oubliez pas de désactiver la commande juste après, sinon vous risquez de
constater un passage étrangement faible sur votre site.<br />
Exemples:<br />
\$BBC_KILL_STATS = 1;<br />
\$BBC_KILL_STATS = &quot;&quot;;",

"config_BBC_PURGE_SINGLE" =>
"Les statistiques des noms de domaines et des référents peuvent générer une
énorme quantité de données, malgré tout uniquement à cause de visites uniques.
En utilisant cette commande, vous pouvez purger ces entrées et ainsi diminuer
de façon considérable la taille du fichier access.php, sans pour autant
affecter le véritable classement des noms de domaines et des référents.
Le nombre des requêtes correspondantes sera ajouté aux entrées &quot;Non specifiées&quot;
pour conserver les résultats intacts<br />
Exemples:<br />
\$BBC_PURGE_SINGLE = 1;<br />
\$BBC_PURGE_SINGLE = &quot;&quot;;",

"config_BBC_LOADTIME" =>
"Generate the page load-time in seconds at bottom of the page.<br />
Examples:<br />
\$BBC_LOADTIME =&quot;&quot;;<br />
\$BBC_LOADTIME = 1;",

"config_BBC_EXT_LOOKUP" =>
"This options defines, whether IP addresses are looked up to determine location (country).<br />
These plug-ins are NO part of BBClone, please keep this in mind.<br />
<ul>
<li>IP2EXT => Use the old IP2EXT to Look-Up IP addresses</li>
<li>GEOIP => Use GeoIP API plug-in</li>
<li>GEOIP-mod => Use GeoIP PHP/Perl Module (geoip.so)</li>
</ul>
Examples:<br />
\$BBC_EXT_LOOKUP =&quot;&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;IP2EXT&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP&quot;;<br />
\$BBC_EXT_LOOKUP =&quot;GEOIP-mod&quot;;",

"config_BBC_CSS_FILE" =>
"BBClone CSS File Name<br />
Please note; Within this css file you can change the way BBClone looks.<br />
(for example change colors or what text size/fonts are used)<br />
Examples:<br />
\$BBC_CSS_FILE =&quot;bbclone.css&quot;;<br />
\$BBC_CSS_FILE =&quot;other.css&quot;;",

"config_BBC_HITS" =>
"Include BBClone hits within the Stats<br />
Examples:<br />
\$BBC_HITS =1;<br />
\$BBC_HITS =&quot;&quot;;",

"config_BBC_USE_ORIGINAL_URI" =>
"Enable this option when the &quot;Top Visited Pages&quot; URI's are not working due
filtering of the URI. This can happen if you use BBClone with some Content
Management Systems (CMS) which are using very long (complex) URI naming.<br />
IMPORTED NOTE: This option changes how URI's are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_USE_ORIGINAL_URI = 1;	=> No filtering, use original URI<br />
\$BBC_USE_ORIGINAL_URI = &quot;&quot;;	=> Filter URI (default)",

"config_BBC_MAX_PAGENAME" =>
"The max. number of characters for the page name.<br />
Longer page names will be stript down at the front, leading with &quot;...&quot;<br />
IMPORTED NOTE: This option changes how page names are recorded,
so you may need to reset the stats.<br />
Examples:<br />
\$BBC_MAX_PAGENAME = 60;	=> 60 characters (default)"

);
?>
